<?php
/*
// File written by Jochen "Khuri" Dippel <khuri@khuris.com>
// Copyright 2014
//
// File        : index.php
// Begin       : 2011.09.27 11:38:19
// Last Update : 2014.02.01 17:18:02
*/

/* CONFIGURATION */

// Mainfolder name
$rootfolder_name = "Meine Bilder"; // name of the root folder displayed
$rootfolder_displayname = true; // use $rootfolder_name instead of actual folder name

// Login data
$hide_adminpanel = false; // do not display adminpanel login
$admin_password = "abc123"; // password for admin panel
$require_password = false; // password required to view files?
$password_string = "test"; // the password, only used if $require_password is true

// Thumbnails
$thumbnail_folder = "./_thumbnails/"; // thumbnails stored here
$thumbnail_quality = 80; // 0-100, 100 max, quality JPEG compression
$thumbnail_x = 320; // width in px
$thumbnail_y = 240; // height in px
$thumbnail['show_imagetext'] = true; // show image description, if exists
$thumbnail['show_name'] = true;
$thumbnail['show_filesize'] = true;
$thumbnail['show_date'] = true;
$thumbnail['show_dimension'] = true;
$thumbnail['show_download'] = true;
$thumbnail['imagesonrow'] = 5;
$thumbnail['show_highresdownload'] = false; // expects the same filename to exist in subfolder $hdfolder
$hdfolder = "_highres"; // folder for highres images
$thumbnail['showhistory'] = array('image','imagetext','download','name','filesize','date','dimension','highresdownload'); // how to display the textboxes

// Options
$link_to_subfolder = true; // scan for subfolders and create link
$subfolder_fancy = true; // display subfolder link with images
$subfolder_fancycount = 3; // how many images to display
$foldername_nice = true; // show the foldernames "nice"
$filename_nice = true; // show the filenames "nice"
$date_stamp = "d.m.Y H:i"; // Date format
$filefilter = "/index\.php|php_errors\.log|_highres|imagetext\.csv/i"; // regex filter
$thisfile = "index.php"; // this file

// Language
$L = array();
$L['subfolder'] = "Ordner";
$L['files'] = "Bilder dieses Ordners (%s)";
$L['folder_parent'] = "..übergeordneter Ordner";
$L['thumbnail_missing'] = "Es wurden neue Bilder entdeckt, die noch keine Vorschau haben.<br />Sollen die Vorschau-Dateien jetzt erstellt werden?";
$L['thumbnail_create_btn'] = "Vorschaubilder erstellen";
$L['thumbnail_sum'] = "Erstelle Vorschaubilder...<br />Noch <strong>%s</strong> Bilder verbleibend.<br />Bitte haben Sie einen Moment Geduld. Dieses Browserfenster wird sich regelmäßig aktualisieren!";
$L['error_folder'] = "Fehler!<br />Kann Vorschau-Ordner nicht erstellen: <pre>%s</pre><br />Bitte Rechte des momentanen Ordners überprüfen und ggfs. auf 766 setzen!";
$L['error_thumbnail'] = "Fehler!<br />Kann Vorschau-Dateien nicht erstellen: <pre>%s</pre><br />Bitte Rechte des momentanen Ordners überprüfen und ggfs. auf 766 setzen!";
$L['error_filenotfound'] = "Fehler!<br />Kann die Datei leider nicht auf dem Dateisystem finden.";
$L['title'] = "Ordner '%s'";
$L['nofiles'] = "Ordner leider leer.";
$L['download'] = "Speichern";
$L['download_highres'] = "Speichern HD";
$L['title_login'] = "Login";
$L['password'] = "Passwort";
$L['login_btn'] = "Anmelden";
$L['title_admin'] = "Verwaltung";
$L['title_admin_cleanup'] = "Vorschaubilder löschen";
$L['admin_cleanup'] = "Vorschaubilder löschen:";
$L['admin_cleanup_all'] = "- Alle Ordner -";
$L['admin_btn_submit'] = "Ausführen";
$L['admin_backtopage'] = "Zurück zur Bilderseite";
$L['admin_done'] = "Aktion ausgeführt";
$L['title_admin_textfolder'] = "Bildtexte verwalten";
$L['admin_textfolder'] = "Ordner wechseln:";
$L['admin_btn_switch'] = "Wechseln";
$L['admin_btn_save'] = "Texte Speichern";
$L['js_fullscreenimg_js_info'] = "Tipp: Benutzen Sie die Pfeiltasten rechts/links auf Ihrer Tastatur zum Scrollen.";
$L['js_fullscreenimg_js_image'] = "Bild %1 / %2";
$L['js_fullscreenimg_js_image_connector'] = " - ";
$L['js_fullscreenimg_js_error_notfound'] = 'Fehler!\n%1\nDatei kann nicht geladen werden!';
$L['js_fullscreenimg_js_image_fullscreen'] = "Das Bild ist zu groß für Ihren Bildschirm. Klicken Sie hier um das Bild in Originalgröße in einem neuen Fenster zu öffnen.";

/* CONFIGURATION END */


/* FILE CLASS (shortened version) */

class files {
	var $page_file = '';
	var $folder_tree = array();
	var $folder_array = array();
	var $file_array = array();
	var $file_handler = false;
	var $current_folder = '';
	var $imagetext_settings = array();
	var $thumbnail_folder = "";
	var $hdfolder = "";

	function __set($var,$value) {
		$this->$var = $value;
	}
	function __get($var) {
		return $this->$var;
	}
	function __construct() {
		global $thumbnail_folder,$hdfolder;
		$this->thumbnail_folder = $thumbnail_folder;
		$this->hdfolder = $hdfolder;
	}
	// Primary functions
	function setfile($page_file,$upload=0,$tmp_file=false,$tmp_file_name=false) {
		// If $page_file contains folders, then call setfolder first
		if(isset($page_file['name']) && strpos($page_file['name'],"/") !== false) {
			$this->setfolder(substr($page_file['name'],0,strrpos($page_file['name'],"/")),1);
			// Get filename only
			$page_file['name'] = substr(strrchr($page_file['name'],"/"),1);
		}
		$this->page_file = ($upload == 1) ? ((!$tmp_file) ? $page_file['tmp_name'] : $tmp_file) : $this->current_folder.$page_file;
		$this->page_file_name = ($upload == 1) ? $this->name_check(((!$tmp_file_name) ? $page_file['name'] : $tmp_file_name)) : $this->name_check($page_file);
		$this->image_info = ($upload == 1) ? @getimagesize(((!$tmp_file) ? $page_file['tmp_name'] : $tmp_file)) : @getimagesize($this->page_file);
	}
	function setfolder($page_folder='',$from_root=0,$cancreate=1) {
		global $SITE_CONFIG;
		// check if last char is an /
		$page_folder = (substr($page_folder,-1) == "/" || $page_folder == "") ? $page_folder : $page_folder."/";
		$this->current_folder = (($from_root==0) ? $SITE_CONFIG['USER_FOLDER'] : "").$page_folder;
		// if folder does not exists, try to create it
		$folder_arr = explode("/",$page_folder);
		$folder_string = "";
		$folder_check = true;
		foreach($folder_arr as $id => $folder) {
			if($folder != "") {
				$folder_string = (($folder_string != "") ? $folder_string."/" : "").$folder;
				$folder_current = (($from_root==0) ? $SITE_CONFIG['USER_FOLDER'] : "").$folder_string;
				if(!is_dir($folder_current) && $cancreate == 1) {
					@mkdir($folder_current,0777);
					$folder_check = @chmod($folder_current,0777);
				}
			}
		}
		return $folder_check;
	}

	function writefile($content="",$mode="wb",$closefile=true,$openfile=true,$limit=false) {
		global $LANG_ARRAY;
		// open file handler
		if($openfile) {
			// Close old file first, if open
			@fclose($this->file_handler);
			$this->file_handler = false;
			$this->file_handler = @fopen($this->page_file,$mode);
		}
		// if file is opened, write
		if($this->file_handler) {
			if($limit) {
				@fwrite($this->file_handler,$content,$limit);
			}
			else {
				@fwrite($this->file_handler,$content);
			}
		}
		else {
			return false;
		}
		if($closefile) {
			@fclose($this->file_handler);
			$this->file_handler = false;
		}
		return true;
	}

	function find_file($filename,$scan_sub=0,$delete_file=1,$delete_all=0) {
		// Scan the current folder
		$found_all = false;
		$this->folder_scan($scan_sub);
		if($this->folder_recieve(0) != '') {
			foreach($this->folder_recieve(0) as $id => $name) {
				if(stristr($name,$filename)) {
					if($delete_all == 1) {
						$this->deletefile($name);
						$found_all = true;
					}
					else {
						if($delete_file == 1) {
							$this->deletefile($name);
						}
						return $name;
					}
				}
			}
		}
		return ($found_all) ? true : false;
	}

	// File structure and handling
	function uploadfile() {
		return @move_uploaded_file($this->page_file,$this->current_folder.$this->name_check($this->page_file_name));
	}
	function deletefile($page_file) {
		if(is_file($this->current_folder.$page_file)) {
			if(@unlink($this->current_folder.$page_file)) {
				@unlink($this->current_folder.$this->thumbnail_folder.$page_file);
				return true;
			}
		}
		return false;
	}
	function deletefolder($page_folder='') {
		if(is_dir($this->current_folder.$page_folder)) {
			@rmdir($this->current_folder.$page_folder.$this->thumbnail_folder);
			if(@rmdir($this->current_folder.$page_folder)) {
				return true;
			}
		}
		return false;
	}
	function chmodfile($mode,$name=false) {
		$name = ($name === false) ? $this->page_file : $name;
		return @chmod($this->current_folder.$name,$mode);
	}
	function renamefile($path,$oldname,$newname,$move="") {
		// rename possible thumbnail first
		@rename($path.$this->thumbnail_folder.$oldname,(($move != "") ? $move : $path).$this->thumbnail_folder.$this->name_check($newname));
		return @rename($path.$oldname,(($move != "") ? $move : $path).$this->name_check($newname));
	}
	function copyfile($path,$name,$move,$newname=false) {
		// use current filename or give target a new name
		$newname = ($newname) ? $newname : $name;
		// copy possible thumbnail first
		@copy($path.$this->thumbnail_folder.$name,$move.$this->thumbnail_folder.$this->name_check($newname));
		return @copy($path.$name,$move.$this->name_check($newname));
	}
	function movefile($path,$name,$move,$newname=false) {
		// First copy, then delete old
		if($this->copyfile($path,$name,$move,$newname)) {
			@unlink($path.$this->thumbnail_folder.$name);
			if(@unlink($path.$name)) {
				return true;
			}
			else {
				return 'cannot_delete';
			}
		}
		return false;
	}
	function name_check($name) {
		// first make lowercase and replace umlaute and spaces
		$name = str_replace(array(" ","ä","ö","ü","ß","Ä","Ö","Ü"),array("_","ae","oe","ue","ss","ae","oe","ue"),utf8_decode($name));
		$name = strtolower($name);
		// replace all bad chars
		$name = preg_replace('/[^0-9A-Za-z\-_.]/i','',$name);
		return $name;
	}
	function folder_clean() {
		$this->folder_tree = array();
	}
	function filter_name($handle,$filter,$filter_who=0) {
		if(($filter_who == 0 && is_file($this->current_folder.$handle)) || ($filter_who == 1 && is_dir($this->current_folder.$handle)) || ($filter_who >= 2)) {
			if(preg_match($filter,$handle) >= 1) {
				return true;
			}
			else {
				return false;
			}
		}
		return true;
	}
	function folder_scan($scan_deeper=1,$no_files=0,$filter=false,$exclude=false,$folder='') {
		$read_dir = @opendir($this->current_folder.$folder);
		@rewinddir($read_dir);
		while($files = @readdir($read_dir)) {
			// create directory entry, then fill with data if not empty
			if(empty($this->folder_tree[$this->current_folder.$folder])) {
				$this->folder_tree[$this->current_folder.$folder] = array("folder"=>array(),"file"=>array());
			}
			// Get File/Directory Names
			if($files != "." && $files != ".." && $files != preg_replace('%[/.]%','',$this->thumbnail_folder) && $files != preg_replace('%[./]%','',$this->hdfolder) && !preg_match('/^\.[a-z_.0-9]*$/i',$files)) {
				if(is_dir($this->current_folder.$folder.$files)) {
					$this->folder_tree[$this->current_folder.$folder]["folder"][] = $files;
					if($scan_deeper == 1) {
						$this->folder_scan($scan_deeper,$no_files,$filter,$exclude,$folder.$files."/",0);
					}
				}
				elseif($no_files == 0 && (($filter && preg_match($filter,$files)) || !$filter) && (($exclude && @!preg_match($exclude,$files)) || !$exclude)) {
					$this->folder_tree[$this->current_folder.$folder]["file"][] = $files;
				}
			}
			// sort the recieved data
			natsort($this->folder_tree[$this->current_folder.$folder]["folder"]);
			natsort($this->folder_tree[$this->current_folder.$folder]["file"]);
		}
		@closedir($read_dir);
	}
	function folder_sort($order_command="sort",$order=SORT_REGULAR,$sortwho=array("folder","file"),$folder='') {
		if(is_array($this->folder_tree)) {
			if(isset($this->folder_tree[$this->current_folder.$folder]) && is_array($this->folder_tree[$this->current_folder.$folder])) {
				foreach($sortwho as $id => $a) {
					switch($order_command) {
						case "arsort": arsort($this->folder_tree[$this->current_folder.$folder][$a],$order);break;
						case "asort": asort($this->folder_tree[$this->current_folder.$folder][$a],$order);break;
						case "ksort": ksort($this->folder_tree[$this->current_folder.$folder][$a],$order);break;
						case "krsort": krsort($this->folder_tree[$this->current_folder.$folder][$a],$order);break;
						case "natsort": natsort($this->folder_tree[$this->current_folder.$folder][$a]);break;
						case "natcasesort": natcasesort($this->folder_tree[$this->current_folder.$folder][$a]);break;
						case "rsort": rsort($this->folder_tree[$this->current_folder.$folder][$a],$order);break;
						default: sort($this->folder_tree[$this->current_folder.$folder][$a],$order);break;
					}
				}
			}
		}
	}
	function folder_recieve($get_folder=0,$specific_folder=0) {
		if(($specific_folder !== 0 && !empty($this->folder_tree[$specific_folder])) || !empty($this->folder_tree[$this->current_folder])) {
			return ($specific_folder !== 0) ? (($get_folder == 1) ? $this->folder_tree[$specific_folder]["folder"] : $this->folder_tree[$specific_folder]["file"]) : (($get_folder == 1) ? $this->folder_tree[$this->current_folder]["folder"] : $this->folder_tree[$this->current_folder]["file"]);
		}
		return array();
	}
	function file_size($size,$usefile=false) {
		if($usefile) {
			$size = @filesize($this->current_folder.$this->page_file);
		}
		return (($size >= 1000000000) ? (number_format($size / 1000000000,2,'.',',')." GB") : (($size >= 1000000) ? (number_format($size / 1000000,2,'.',',')." MB") : (($size >= 1000) ? (number_format($size / 1000,2,'.',',')." kB") : ($size." b"))));
	}
	function file_icon($ext,$filename='') {
		if($filename != "") {
			$ext = substr(strrchr($filename,"."),1);
		}
		$ext = strtolower($ext);
		switch($ext) {
			case "pdf": return "pdf";
			case "jpg":
			case "jpeg":
			case "jpe":
			case "png":
			case "gif":
			case "bmp":
			case "tiff":
			case "tif": return "image";
			case "rar":
			case "zip":
			case "7z":
			case "tar": return "archive";
			case "rtf":
			case "doc":
			case "docx": return "doc";
			case "xlsx":
			case "xls":
			case "xlt":
			case "xlm":
			case "xld":
			case "xla":
			case "xlc":
			case "xlw":
			case "xll": return "xls";
			case "pptx":
			case "ppt":
			case "pps": return "ppt";
			case "exe": return "exe";
			case "mpeg":
			case "mpg":
			case "mpe":
			case "mp3":
			case "wav":
			case "aiff":
			case "aif":
			case "avi":
			case "wmv":
			case "mov":
			case "swf": return "media";
			default: return "unknown";
		}
	}
	function file_mime($ext,$filename='') {
		if(function_exists("finfo_file") && $filename != '') {
			$finfo = finfo_open(FILEINFO_MIME);
			$ext_finfo = finfo_file($finfo,$filename);
			finfo_close($finfo);
			return $ext_finfo;
		}
		else {
			if($filename != "") {
				$ext = substr(strrchr($filename,"."),1);
			}
			$ext = strtolower($ext);
			switch($ext) {
				case "js": return "application/x-javascript";
				case "json": return "application/json";
				case "jpg":
				case "jpeg":
				case "jpe": return "image/jpeg";
				case "png":
				case "gif":
				case "bmp": return "image/".$ext;
				case "tiff":
				case "tif": return "image/tif";
				case "css": return "text/css";
				case "xml": return "application/xml";
				case "doc":
				case "docx": return "application/msword";
				case "xlsx":
				case "xls":
				case "xlt":
				case "xlm":
				case "xld":
				case "xla":
				case "xlc":
				case "xlw":
				case "xll": return "application/vnd.ms-excel";
				case "pptx":
				case "ppt":
				case "pps": return "application/vnd.ms-powerpoint";
				case "rtf": return "application/rtf";
				case "pdf": return "application/pdf";
				case "html":
				case "htm":
				case "php": return "text/html";
				case "txt": return "text/plain";
				case "mpeg":
				case "mpg":
				case "mpe": return "video/mpeg";
				case "mp3": return "audio/mpeg3";
				case "wav": return "audio/wav";
				case "aiff":
				case "aif": return "audio/aiff";
				case "avi": return "video/msvideo";
				case "wmv": return "video/x-ms-wmv";
				case "mov": return "video/quicktime";
				case "rar": return "application/rar";
				case "zip": return "application/zip";
				case "7z": return "application/7z";
				case "tar": return "application/x-tar";
				case "swf": return "application/x-shockwave-flash";
				default: return "unknown/".$ext;
			}
		}
	}

	// Image handling
	function setmemoryforimage() {
		$memoryneeded = round(($this->image_info[0] * $this->image_info[1] * $this->image_info['bits'] * ((isset($this->image_info['channels'])) ? $this->image_info['channels'] : 3) / 8 + pow(2, 16)) * 1.65);
		$memorylimit = (int) ini_get('memory_limit') * 1048576;

		if(function_exists("memory_get_usage")) {
			if((memory_get_usage() + $memoryneeded) > $memorylimit) {
				if(ini_set('memory_limit',ceil(($memoryneeded + $memorylimit)/1048576).'M')) {
					return true;
				}
				else {
					die("<strong>Error:</strong><br>Could not assign enough memory for function!<br>Memory required: ".ceil($memoryneeded / 1048576)."MB<br>Source file probably too big;!");
				}
			}
		}
		return true;
	}

	function resample_image($max_x,$max_y,$new_name,$force_resize=0,$force_filetype=0,$thumbnail=0,$quality=80,$sendtobrowser=0,$uppercasefile=0) {
		if($sendtobrowser == 0) {
			if(!is_dir($this->current_folder)) {
				$this->setfolder($this->current_folder,1);
			}
			if($thumbnail == 1 && !is_dir($this->thumbnail_folder.$this->current_folder)) {
				$b = $this->current_folder;
				$this->setfolder($this->thumbnail_folder.$this->current_folder,1);
				$this->setfolder($b,1);
			}
		}
		// Set the required memory for the image
		$this->setmemoryforimage();
		// Define filetype
		$target_filetype = ($force_filetype > 0) ? $force_filetype : $this->image_info[2];
		switch($target_filetype) {
			case 1: $filetype='gif';break;
			case 3: $filetype='png';break;
			case 2:
			default: $filetype='jpg';break;
		}
		$filetype = ($uppercasefile > 0) ? strtoupper($filetype) : $filetype;
		$newname = $new_name.".".$filetype;
		$file_upload_local = $this->page_file;
		$file_upload_local_new = (($thumbnail == 1) ? $this->thumbnail_folder.$this->current_folder : $this->current_folder).$newname;

		// original image sizes
		$orig_x = $this->image_info[0];
		$orig_y = $this->image_info[1];

		// Does the image exceed the limit or is force resize on?
		if(($orig_x > $max_x || $orig_y > $max_y || $force_resize == 1 || $sendtobrowser != 0 || ($force_filetype > 0 && $force_filetype != $this->image_info[2])) && $this->image_info[2] >= 1 && $this->image_info[2] <= 3) {
			// what image do we have here?
			$img_source = ($this->image_info[2] == 1) ? imagecreatefromgif($file_upload_local) : (($this->image_info[2] == 3) ? imagecreatefrompng($file_upload_local) : imagecreatefromjpeg($file_upload_local));

			// Force resize or "nice" resize?
			if($force_resize == 1) {
				$new_x = $max_x;
				$new_y = $max_y;
			}
			else {
				// set the new sizes
				$new_x = $orig_x;
				$new_y = $orig_y;
				// nice resize
				if($orig_x > $max_x || $orig_y > $max_y) {
					$new_x = $max_x;
					$new_y = round($new_x * $orig_y / $orig_x);
					// if new_y is bigger then max_y do a loop until it's smaller
					while($new_y > $max_y) {
						$new_x--;
						$new_y = round($new_x * $orig_y / $orig_x);
					}
				}
			}
			$img_new = imagecreatetruecolor($new_x, $new_y);
			// Enable transparency?
			if($force_filetype == 1 || $force_filetype == 3) {
				imagealphablending($img_new,false);
				imagesavealpha($img_new,true);
				$transparent = imagecolorallocatealpha($img_new, 255, 255, 255, 127);
				imagefilledrectangle($img_new, 0, 0, $new_x, $new_y, $transparent);
			}
			// else replace transparency with white
			else {
				$white = imagecolorallocate($img_source, 255, 255, 255);
				imagecolortransparent($img_source,$white);
			}
			imagecopyresampled($img_new, $img_source, 0, 0, 0, 0, $new_x, $new_y, $orig_x, $orig_y);

			// Put text on image if requested
			if(!empty($this->imagetext_settings)) {
				$this->imagetext_paste($img_new,$new_x,$new_y);
			}

			if($sendtobrowser != 0) {
				header("Cache-control: no-cache, no-store");
				header("Content-type: image/".(($target_filetype == 2) ? "jpeg" : $target_filetype));
			}
			if($target_filetype == 1 && imagegif($img_new,(($sendtobrowser == 0) ? $file_upload_local_new : ''))) {
				return true;
			}
			elseif($target_filetype == 2 && imagejpeg($img_new,(($sendtobrowser == 0) ? $file_upload_local_new : ''),$quality)) {
				return true;
			}
			elseif($target_filetype == 3 && imagepng($img_new,(($sendtobrowser == 0) ? $file_upload_local_new : ''))) {
				return true;
			}
			else {
				return false;
			}
		}
		elseif($this->image_info[2] >= 1 && $this->image_info[2] <= 3) {
			if(@copy($file_upload_local,$file_upload_local_new)) {
				return true;
			}
			else {
				return false;
			}
		}
		else {
			return false;
		}
	}
}

/* We need to do several checks before printing any output */

// Requires login?
$login_okay = false;
if($require_password) {
	session_start();
	if(isset($_SESSION['login']) && $_SESSION['login'] == $password_string) {
		$login_okay = true;
	}
	else {
		if(isset($_POST['login']) && $_POST['login'] == $password_string) {
			$_SESSION['login'] = $_POST['login'];
			$login_okay = true;
		}
		else {
			$login_okay = false;
		}
	}
}
else {
	$login_okay = true;
}

// Configure certain variables
$subfolder = (isset($_GET['folder'])) ? str_replace(array("/..","../"),"",trim($_GET['folder'])) : "";
$subfolder = ($subfolder != "") ? (!preg_match('%/$%',$subfolder) ? $subfolder."/" : $subfolder) : "";
$filedownload = (isset($_GET['filedownload'])) ? str_replace(array("/..","../"),"",trim($_GET['filedownload'])) : "";
$cif = (isset($_GET['cif'])) ? (bool) $_GET['cif'] : false;
$showadminpanel = (isset($_GET['adminpanel']) && $_GET['adminpanel'] == "true") ? true : false;

// admin login
if($showadminpanel) {
	$login_admin = false;
	if(session_id() == "") {
		session_start();
	}
	if(isset($_SESSION['adminlogin']) && $_SESSION['adminlogin'] == $admin_password) {
		$login_admin = true;
	}
	else {
		if(isset($_POST['adminlogin']) && $_POST['adminlogin'] == $admin_password) {
			$_SESSION['adminlogin'] = $_POST['adminlogin'];
			$login_admin = true;
		}
		else {
			$login_admin = false;
		}
	}
}
// Get files and folders
$files = new files();
$files->setfolder("./".$subfolder,1,0);
$files->folder_scan(0,0,false,$filefilter);
$files->folder_sort("natcasesort");
$cfolders = $files->folder_recieve(1,0);
$cfiles = $files->folder_recieve(0,0);

// Ignore everything if !login_okay
if($login_okay && !$showadminpanel) {
	// Trigger download dialog
	if($filedownload != "") {
		if(file_exists($subfolder.$filedownload)) {
			$files = new files();
			// file info
			$filesize = filesize($subfolder.$filedownload);
			header("Content-Type: ".$files->file_mime("",$filedownload));
			header("Content-Disposition: attachment; filename=".$filedownload);
			header("Content-Length: ".$filesize);
			header("Pragma: no-cache");
			header("Expires: 0");
			readfile($subfolder.$filedownload);
			exit();
		}
		exit($L['error_filenotfound']);
	}
	// Check all images first
	$image_sum = 0;
	$image_missing = 0;
	$images_missing_array = array();
	$images_error = false;

	// Create next thumbnail
	if(!empty($cfiles)) {
		foreach($cfiles as $id => $name) {
			if(!file_exists($thumbnail_folder.$subfolder.preg_replace('/\.[a-z0-9]+$/i','',$name).".jpg") && !file_exists($thumbnail_folder.$subfolder.preg_replace('/\.[a-z0-9]+$/i','',$name).".JPG")) {
				$image_missing++;
				$images_missing_array[] = $name;
			}
			$image_sum++;
		}
		if($image_missing > 0 && $cif) {
			$files->setfolder("./".$subfolder,1,0);
			$files->setfile($images_missing_array[0]);
			$new_name = preg_replace('/\.[a-z0-9]+$/i','',basename($images_missing_array[0]));
			if(!$files->resample_image($thumbnail_x,$thumbnail_y,$new_name,0,2,1,$thumbnail_quality,0,((preg_match('/\.([A-Z]+)$/',$images_missing_array[0]))?1:0))) {
				$images_error = true;
			}
		}
	}
}

// Define UTF-8 headers, just to be sure
header('Content-Type: text/html; charset=utf-8');

// Foldername
if($rootfolder_displayname) {
	$foldername = $rootfolder_name;
}
else {
	$foldername = explode("/",$_SERVER['SCRIPT_FILENAME']);
	$foldername = $foldername[(count($foldername)-2)];
}
$subfolderarr = explode("/",preg_replace("%/$%","",$subfolder));
$foldername = ($subfolder != "") ? $foldername." / ".implode(" / ",$subfolderarr) : $foldername;

?>

<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8" />
<meta name="robots" content="noindex" />
<meta http-equiv="x-ua-compatible" content="IE=edge" />
<link href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAAB3RJTUUH3gIBChwpj86jHQAAAAlwSFlzAAALEgAACxIB0t1+/AAAAARnQU1BAACxjwv8YQUAAAGLSURBVHjaY/iPAW7evtXQ13n3/r3/2AADptCU+bPDijMXrFwGZJ+7fOn+wwcENJy9cC66PM81N8GnKFUzzkc+yq1h1sRv375h1/D23du8tjqvohTLtHDFUCceHzPeYGv9nPCeOdOwa6ib1B1UmWORHMLpbsTuYSQZ4mCeET592cL3799j0XDmwvmomkKn3Dh2NwP1SA9+f0uDlKAjp05g8cOLly9Wbd4QUVvgXZauGeXB4KZnmBLUMnOiVpL/pt07sGhYv31LaGVuaEWOc1GSVLAdh7eJfXa0aXZk/8LZ2IP17bt3RR0N2c3VRf2tkuGOy9etXLhxtWCEfWFPM754+Pz58/JtG6Xi3CyyIxZtXL1+57YHDx8SiLg/f/4E1+YxB5oLRTgcO3uaqJgGgo750+WTfYr6WnFqiKgp+PnzJ1wUGK+6OWGVk7pwaiie2NY4cwKE/f7Dh7SeepP86H1HDuFzUsnENvu8uMDaXPWUAIucqKXr12B1LYoflm5YHV2Z1ztn+tOnT//jAABz62BuzWnZ1gAAAABJRU5ErkJggg==" rel="icon" type="image/x-icon" />
<?php
// Do redirect for thumbnail generation?
if($cif && !$images_error && $image_missing > 0) {
	echo '<meta http-equiv="refresh" content="1; url='.$thisfile.'?folder='.$subfolder.'&amp;cif=true">';
}
else {
	$cif = false;
}
?>
<title>
	<?php
		echo sprintf($L['title'],(($foldername_nice) ? ucwords($foldername) : $foldername));
	?>
</title>
<style rel="stylesheet" type="text/css">
* {
	margin: 0px;
	padding: 0px;
	border: 0px;
}
body {
	background-color: #000;
	padding: 20px;
	overflow: visible;
	overflow-y: scroll;
	overflow-x: auto;
}
body, td, pre {
	color: #eee;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 11pt;
	line-height: 16pt;
}
fieldset {
	border: 1px solid #C0C0C0;
	padding: 10px 6px 6px 6px;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	background: #45484d;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzQ1NDg0ZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMwMDAwMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top, #45484d 0%, #000000 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#45484d), color-stop(100%,#000000));
	background: -webkit-linear-gradient(top, #45484d 0%,#000000 100%);
	background: -o-linear-gradient(top, #45484d 0%,#000000 100%);
	background: -ms-linear-gradient(top, #45484d 0%,#000000 100%);
	background: linear-gradient(to bottom, #45484d 0%,#000000 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#45484d', endColorstr='#000000',GradientType=0 );
}
fieldset td {
	vertical-align: top;
}
legend {
	margin: 0px 6px 0px 6px;
	padding: 2px 8px;
	font-weight: bold;
	border: 1px solid #C0C0C0;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	background: #45484d;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzQ1NDg0ZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMwMDAwMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top, #45484d 0%, #000000 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#45484d), color-stop(100%,#000000));
	background: -webkit-linear-gradient(top, #45484d 0%,#000000 100%);
	background: -o-linear-gradient(top, #45484d 0%,#000000 100%);
	background: -ms-linear-gradient(top, #45484d 0%,#000000 100%);
	background: linear-gradient(to bottom, #45484d 0%,#000000 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#45484d', endColorstr='#000000',GradientType=0 );
}
pre {font-family: Courier,Courier New,sans-serif;}
hr {
	border-bottom: 1px solid #4d5555;
	width: 100%;
	margin: 8px 0px;
}
ul {
	padding: 4px 0px 4px 14px;
	list-style-type: disc;
}
ol {padding: 4px 0px 4px 22px;}
p {padding: 1em 0 1em;}
h1,h2,h3,h4 {
	font-size: 100%;
	line-height: 1.2em;
	font-weight: bold;
	padding: 0 0 1em;
	color: #ddd;
}
h1 {
	font-weight: normal;
	font-size: 140%;
}
h2 {
	font-size: 130%;
}
img {border: 0px;}
blockquote {margin-left: 20px;}

a {
	color: #eee;
	text-decoration: none;
}
a:hover {
	color: #FF5353;
	text-decoration: underline;
	cursor: pointer;
}
input, select, textarea, select, *.btn {
	text-decoration: none;
	color: #fff;
	border: 1px solid #fff;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	padding: 4px 8px;
	margin: 0 4px;
	font-weight: bold;
	background: #b5bdc8;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2I1YmRjOCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjM2JSIgc3RvcC1jb2xvcj0iIzgyOGM5NSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMyODM0M2IiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top, #b5bdc8 0%, #828c95 36%, #28343b 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#b5bdc8), color-stop(36%,#828c95), color-stop(100%,#28343b));
	background: -webkit-linear-gradient(top, #b5bdc8 0%,#828c95 36%,#28343b 100%);
	background: -o-linear-gradient(top, #b5bdc8 0%,#828c95 36%,#28343b 100%);
	background: -ms-linear-gradient(top, #b5bdc8 0%,#828c95 36%,#28343b 100%);
	background: linear-gradient(to bottom, #b5bdc8 0%,#828c95 36%,#28343b 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#b5bdc8', endColorstr='#28343b',GradientType=0 );
}
input:hover, textarea:hover, select:hover, option:hover, option:checked, *.btn:hover {
	text-decoration: none;
	color: #f9efe5;
	background: #f47e10;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2Y0N2UxMCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjQ3JSIgc3RvcC1jb2xvcj0iI2Q0NmUwZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNhZTViMGUiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top,  #f47e10 0%, #d46e0e 47%, #ae5b0e 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#f47e10), color-stop(47%,#d46e0e), color-stop(100%,#ae5b0e));
	background: -webkit-linear-gradient(top,  #f47e10 0%,#d46e0e 47%,#ae5b0e 100%);
	background: -o-linear-gradient(top,  #f47e10 0%,#d46e0e 47%,#ae5b0e 100%);
	background: -ms-linear-gradient(top,  #f47e10 0%,#d46e0e 47%,#ae5b0e 100%);
	background: linear-gradient(to bottom,  #f47e10 0%,#d46e0e 47%,#ae5b0e 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#f47e10', endColorstr='#ae5b0e',GradientType=0 );
}
*.btn {
	font-size: 8pt;
}
*.pointer {
	cursor: pointer;
}
ul.subfolder {
	padding: 4px 0px 4px 24px;
	list-style-type: disc;
}
ul.subfolder a {
	font-weight: bold;
	display: block;
}
ul.subfolderfancy {
	padding: 0;
	list-style-type: none;
	width: auto;
}
ul.subfolderfancy li {
	position: relative;
	display: inline-block;
	width: 20%;
	height: 200px;
}
ul.subfolderfancy li a {
	position: absolute;
	width: 100%;
	height: 200px;
}
ul.subfolderfancy li a div.textlink {
	position: absolute;
	left: 0;
	bottom: 6px;
	width: 100%;
	text-align: center;
}
ul.subfolderfancy li img, div.blankcard {
	position: absolute;
	width: 40%;
	height: auto;
	max-height: 100%;
	top: 15%;
	left: 55%;
	margin: 0 0 0 -25%;
	border: 3px solid #fff;
	-webkit-box-shadow: 3px 3px 6px #000000;
	-moz-box-shadow: 3px 3px 6px #000000;
	box-shadow: 3px 3px 6px #000000;
}
ul.subfolderfancy li div.blankcard {
	height: 60% !important;
	background: #2d3033;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzJkMzAzMyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM0NTQ4NGQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top, #2d3033 0%, #45484d 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#2d3033), color-stop(100%,#45484d));
	background: -webkit-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: -o-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: -ms-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: linear-gradient(to bottom, #2d3033 0%,#45484d 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#2d3033', endColorstr='#45484d',GradientType=0 );
}
ul.subfolderfancy .r1 {
	-webkit-transform: rotate(-5deg) translate(-20%, -5%);
	-moz-transform: rotate(-5deg) translate(-20%, -5%);
	-o-transform: rotate(-5deg) translate(-20%, -5%);
	-ms-transform: rotate(-5deg) translate(-20%, -5%);
	transform: rotate(-5deg) translate(-20%, -5%);
}
ul.subfolderfancy div.blankcard div {
	position: absolute;
	top: 30%;
	left: 10%;
	margin: 0 -5%;
	width: 90%;
	text-align: center;
	font-size: 40pt;
}
ul.subfolderfancy .r2 {
	-webkit-transform: rotate(-1deg) translate(-0%, -15%);
	-moz-transform: rotate(-1deg) translate(-0%, -15%);
	-o-transform: rotate(-1deg) translate(-0%, -15%);
	-ms-transform: rotate(-1deg) translate(-0%, -15%);
	transform: rotate(-1deg) translate(-0%, -15%);
}
ul.subfolderfancy .r3 {
	-webkit-transform: rotate(5deg) translate(15%, 0%);
	-moz-transform: rotate(5deg) translate(15%, 0%);
	-o-transform: rotate(5deg) translate(15%, 0%);
	-ms-transform: rotate(5deg) translate(15%, 0%);
	transform: rotate(5deg) translate(15%, 0%);
}
#photos {
	width: 100%;
	border-spacing: 0;
	border-collapse: separate;
}
#photos td {
  width: <?php echo round(100/$thumbnail['imagesonrow'],2);?>%;
  margin: 10px;
}
#photos td img {
	width: 100% !important;
	height: auto !important;
}
#photos td div.fullimg {
	margin: 6px;
}
#photos td.textinfo {
	font-size: 10pt;
	line-height: 14pt;
}
#photos div.imgname {
	margin: 6px 0;
}
#photos div.dl {
	margin: 6px 0;
}
div.nb {
	position: relative;
	vertical-align: top;
	text-align: center;
	margin: 10px 6px;
	padding: 8px 0;
	border: 1px solid #fff;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	background: #2d3033;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzJkMzAzMyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM0NTQ4NGQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top, #2d3033 0%, #45484d 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#2d3033), color-stop(100%,#45484d));
	background: -webkit-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: -o-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: -ms-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: linear-gradient(to bottom, #2d3033 0%,#45484d 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#2d3033', endColorstr='#45484d',GradientType=0 );
}
div.nb:hover {
	-webkit-box-shadow: 2px 2px 4px 2px #000;
	box-shadow: 2px 2px 4px 2px #000;
}
*.an {
	border-color: #c00;
}
p.anb {
	border-color: #c00;
	font-weight: bold;
}
*.spacel {
	margin-left: 10px;
}
#pageloading {
	position: relative;
	width: 43px;
	height: 11px;
	background: url(data:image/gif;base64,R0lGODlhKwALAPEAAP///wAAAIKCggAAACH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAKwALAAACMoSOCMuW2diD88UKG95W88uF4DaGWFmhZid93pq+pwxnLUnXh8ou+sSz+T64oCAyTBUAACH5BAkKAAAALAAAAAArAAsAAAI9xI4IyyAPYWOxmoTHrHzzmGHe94xkmJifyqFKQ0pwLLgHa82xrekkDrIBZRQab1jyfY7KTtPimixiUsevAAAh+QQJCgAAACwAAAAAKwALAAACPYSOCMswD2FjqZpqW9xv4g8KE7d54XmMpNSgqLoOpgvC60xjNonnyc7p+VKamKw1zDCMR8rp8pksYlKorgAAIfkECQoAAAAsAAAAACsACwAAAkCEjgjLltnYmJS6Bxt+sfq5ZUyoNJ9HHlEqdCfFrqn7DrE2m7Wdj/2y45FkQ13t5itKdshFExC8YCLOEBX6AhQAADsAAAAAAAAAAAA=) no-repeat left top transparent scroll;
	margin: 20px auto;
	display: block;
}
div.imgmiss {
	position: relative;
	width: 22px;
	height: 22px;
	margin: 0 auto;
	background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAACBklEQVR4XrWUTWsTURSG33POpNGkdFEaJygNIsaFko3+hKKbbKxfSxHML1BQsS4raFdaETeJVHdd6G/QhW4jpIgrCQEhgVCHNhkSOh9eL3MhHZvB1PjAyzn3HnjmcBeD/wVB8WTt8Q0Am5gO9x/cW1mzoMHmrZu3Yds2/oVer4eXr9afAjBiaGmj0YCBiEyN92PnxWJR10qlwhZGKJVKmBK0T7z17Ut8DmEGqxCpKgKm6E7HiiqBSZBbsGGwEOOEvYjDECLAKIwpwSyTib/PL+i4Hz7q84+Ll9A8feYAMY8XExPiHKtVdW1fuYqdjTfwOx1klpYm21hYEGd2+TLy79/pvnvnLvztn5g5d3ayjc0wjtdsIn3hvO5D1wXPzSGOsCSJBXGc9Rdwnj1HsLuLwtcts7l+llFI9outcRt77TZ2aq8x+PQZs9evqSdZhpXP49R2FwchxAliEtNqyfzKQ/wtLAliEYY7cMFMKgJhBqnonhgkDCbREiEz03cgYLx48fhJTIW4uNVqJfy9knsFcrncn+JOp4NCoYDDYhwRgRGvbrytPcJ0WK1WqyEholwuHw2CwHYcJ9Pv9zODwSDjed4R3/fTKjNhGFoqQkShisfMeyIyTKVSbjqddrPZbH84HLbr9bpjNjbsqXSj5xGV36KUCkcR9WFi5hCAr84BABV4I3GjO/wCCjepBmZL9t4AAAAASUVORK5CYII=) no-repeat left top transparent scroll;
}
textarea.imgtext {
	width: 80%;
}
#adminbox {
	position: relative;
	float: right;
	width: 24px;
	height: 22px;
	background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAWCAYAAADafVyIAAAAB3RJTUUH3QMTCwsadbvooAAAAAlwSFlzAAAewQAAHsEBw2lUUwAAAARnQU1BAACxjwv8YQUAAAVPSURBVHjajVVrTFNnGD6nPW0ptReudr1AL5NWWgaIMFAUl20xG2rixP3QjC1xMS6bZjFmGSOZ05DJZrLptqjxEokmsh9mv50Ic0DmgBEEBAXUchGwpT2n99OWXvYcNg0gim9yek6/7zvv833P+zzv4RMLQ6LX6/cjft25c2edTqfbMjs7K3Y4HPcxxxIvCD4iKSlJHIvFogvGF62LImEAIObq6uq89evXa8vKyt52Op3SBw8e9CQSCf/zACorKz/cunXrR9PT0zaGYWYWAPB4PBlu5P8A9sHBwVYikSi0Wix6uULBz8nJyR0ZGfFMTk52YU1scfLy8vIthw4dOpWfn1/U09Nz02azDc0HUGDBdxqNZsPExEQbB4Lwj4+Pj1qs1iq1SiWSymTCYDAo7erqasYcMz95Zmamqqam5nR6enrSxYsXj127du0qNhl5Ms8DdTIAvFpfX/9pSUnJZxgTcxMWi+Udg8Ew9wxqCIVCoQXH8vnJZTKZoqqqap/L5XLU1tbua2xsPIONLKCRwssxDhG8i44fP17b0NDwOnYZOnDgwHa5XE7Fov/VzO/3h7DuaQGTk5Mle/fu/QpFFeK9/VNTU7alakPF43H6zp07/SjkW0ajUX7kyJEdGCPw4tz1JPBMY3xOSRkZGUqI4CDLsrzLly/Xeb1e53PVxXEOGfpBR0Vubm46R8eCC2Bx3PEn+datW12g1LFnz54vI5EIBc6P4mT0C+XL/YTD4an29vYeFKoUXEtIkqQi4TBB03QUiQiBUMjjipielvZmcXFxAU7LXLp0qQ7JGWKZIOf/EYlEq3CKdyFLEzcHJU2jDtJt27btLl679hUogoDSPCdOnDjd1tb2A2ibWQ5ggdE4nh8/ftwxMDDQjOv6o0ePmsfv3+90TkyE8tasKRMKhSLQJoKk81NSUgr7+vo68dryFC0RURWfZ6hOU9R8m6VpqLRYt3TQzF06HOZhEys0arWoYuPGnNLS0t1wrhiU2TDueWmAbD6Rd1iffWpXjvn9NEokcY8Ms403/zjTYhudem/79iKpVEpytUlLTU2Gd8ooirL29/f34XSOFwKgILxcAbXua4P+5OZV5vK4L8Bn3W6iY8Y+8FswWP9wxtlitVp3ZGm1ciQj4QtCIBBQhYWFRoigCHIfhWBGkSqxJECpWLT5qMl0ckOWvijomCGDSP7QTTu/dzOfjMSJv5HUMzY25ikoKNgIFyfBFyTnlVAoROZZrZock2nDvXv3Jj0ez+AzACaKV3LMZDpTqFTlsjRNhnw+Yszrdp1lmLq2aPzKk3U+n28SSfVoJRbsnms1c4b0Y71arU5ZvXp1cWtrazcoHJ8DmKNFSJUeNRp/KdFm57FOJxkOBIhh2mU/76brfo/EzsHPT1sEdh20jY7eRV96zWw2Z4vFYhImJHpu374x43C4jQaD2WQycV11GCcb56spvrFWr/vxjSz9uoDdTrJIbnMz9E+Mq+bGbPwCMoefkVg06uzt6+temZlZodFqMyQSCdnU1HQFjidTFAqLSqVaCRlbIPVO/gfpKQd36Vftinq9fNbvJ4bc9NQ5N/NNczR+IT5v54sDJ3GA72GY06rX6ZRrEUql0gzKBCGWJQGihI8E/LqVGVekCVLm9XhifzrsHT97vZ//FY1fjS/xYVkcaHa23t7edpphNNk6nRmuF6EuRAAsoC5kNBbL4qsTMYs7EIg0067r54PsF1BLZ2KezJYLrl0MDQ01owPIQZVOJBQmcxKGGBItLS3XyRUEkbqCJFI9CcKOXux72cSLg/vs4uu2CRL+GD7ZBP6b/unuPvwv/5vIsRUpfy4AAAAASUVORK5CYII=);
}
div.adminlogin {
	position: absolute;
	top: 10px;
	right: 10px;
	visibility: hidden;
	display: none;
	width: 300px;
	text-align: center;
	padding: 8px 0;
	border: 1px solid #fff;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	background: #2d3033;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzJkMzAzMyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM0NTQ4NGQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top, #2d3033 0%, #45484d 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#2d3033), color-stop(100%,#45484d));
	background: -webkit-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: -o-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: -ms-linear-gradient(top, #2d3033 0%,#45484d 100%);
	background: linear-gradient(to bottom, #2d3033 0%,#45484d 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#2d3033', endColorstr='#45484d',GradientType=0 );
}
#adminbox:hover div.adminlogin {
	visibility: visible;
	display: block;
}
#adminlogout {
	position: absolute;
	top: 20px;
	right: 16px;
	text-align: right;
}
.copynote {
	font-size: 8pt;
	text-align: center;
}
.textsmall {
	font-size: 0.8em;
}

/*
// File written by Jochen "Khuri" Dippel <khuri@khuris.com>
// Copyright 2014
//
// File        : shared_fullscreenimg.css
// Begin       : 2011.09.05 12:29:10
// Last Update : 2014.02.01 12:30:22
*/

/* Fullscreen Image */
#fullscreenbox_box {
	position: absolute;
	top: 50%;
	left: 50%;
	width: auto;
	height: auto;
	visibility: hidden;
	padding: 20px 20px 6px 20px;
	border: 1px solid #a9a9a9;
	background: #fff;
	z-index: 1000;
	color: #444;
}
#fullscreenbox_img {
	width: auto;
	height: auto;
	border: 1px #aaa solid;
	z-index: 1000;
}
#fullscreenbox_blackbox {
	position: absolute;
	top: 0px;
	left: 0px;
	width: 100%;
	height: 100%;
	visibility: visible;
	background-color: #000;
	opacity: 0;
	-moz-opacity: 0;
	-khtml-opacity: 0;
	filter: alpha(opacity=0);
	z-index: 900;
}
#fullscreenbox_loadingbox {
	position: fixed;
	top: 50%;
	left: 50%;
	margin-left: -110px;
	margin-top: -80px;
	width: 200px;
	height: 140px;
	padding: 0px;
	border: 10px solid #ddd;
	background-repeat: no-repeat;
	background-position: center center;
	background-color: #fff;
	background-image: url(data:image/gif;base64,R0lGODlhLgAKAIMDAAAAAAAA/0JCQv///8DAwIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD//////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQDCgABACH+MUNyZWF0ZWQgd2l0aCBBbmlNYWtlLiBDb21tZXJjaWFsIHVzZSBmb3JiaWRkZW4uDQoALAAAAAAuAAoAgwAAAAAA/0JCQv///8DAwIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD//////wRQEMhJQ6AY2Fwvn0MohtolnOhZAmm6tqg0ji8s1DDeyjO52befTecC9HymoTC33BmPxFjTNY09e1FVVZvMXWfZYHe3vX1p5bD6I9mw3R84JwIAIfkEAwoAAQAsAAAAAC4ACgCDAAAAAAD/QkJC////wMDAgACAAICAwMDAgICA/wAAAP8A//8AAAD//wD/AP//////BFMQyElDoBjYXC+fQiiG2jWc6FkC47i2ogSTW5q+Mw7LeW2rm5lA1+LtfD+iK5hj9Uy/gTLG3DmP0GS1uHVduVnblHYRGsGAqLRLLTc/K/hG7vlEAAAh+QQDCgABACwAAAAALgAKAIMAAAAAAP9CQkL////AwMCAAIAAgIDAwMCAgID/AAAA/wD//wAAAP//AP8A//////8EUxDISUOgGNhcL59CKIbaNY4lMKzsmp6iBJPbLKRt+84yX/uXHGsH6xV/x6BwQDwZnUioUthEAWzV2GbJjFqxXu00lyVdgeekalm+fSSbd/wz50QAACH5BAMKAAEALAAAAAAuAAoAgwAAAAAA/0JCQv///8DAwIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD//////wRTEMhJQ6AY2Fwvn0Iohto1jiVwiungvq60ktsspHYLv/KM+zXgZcdTCY2rX3JDjCFPSmhwOWz2qE/UVFolXrlZ1lbb3X3JYZrp2Bx8Jpt3/DPnRAAAOw==);
	z-index: 10000;
}
#fullscreenbox_closebutton {
	position: absolute;
	top: 2px;
	right: 0;
	width: 138px;
	height: 20px;
	background-repeat: no-repeat;
	background-position: top right;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAB3RJTUUH3AgZCQkpKOg9igAAAAlwSFlzAAAewQAAHsEBw2lUUwAAAARnQU1BAACxjwv8YQUAAAFQSURBVHjardRbb4IwFAfwY2OCCdvLxgQMEL4BFxMFE747IJfwtO9hBC/D+MhsIwvjUurmeaFN4Jd/T2knVVXBMws1xi//cD7qwbTGLpfLV5ZlsN/vH5Lm8zm4rgscx73fpkWdsMTYZrMBQRCYMVEUyTdpmuJp8WvJOFmSJMyoJEkkWRRFsNvtenvIjGJsvV4TrN0i1H55DMWY4zgQx3FvvzsgDZVlmSTbbreDm9cL9qGLxQJWqxVZZp7ng+2YAqVq1PM8Mg+CAIqioG4WgpGazWbkiU8UQqOv00FFUcC2bfB9nyyV5ZdCNGy5XEIYhnA4HJh/qV5QVVWSDPfseDx2ekpDO6CmaWBZFknWxFhR1MZM0+wkewT9AXVdB8MwyAacTicYqyF0cr9gzev1+omTnc/nUaxZGMOnh+f519u0nDRu7De4X0F/KHw5l82ET6tvTBq4/6qxBpcAAAAASUVORK5CYII=);
	cursor: pointer;
}
#fullscreenbox_text {
	position: relative;
}
#fullscreenbox_cl,#fullscreenbox_cr {
	position: absolute;
	top: 0px;
	height: 100%;
	width: 100px;
	cursor: pointer;
}
#fullscreenbox_cl {
	left: 2px;
	float: left;
	background: transparent no-repeat center left;
}
#fullscreenbox_cr {
	right: 2px;
	float: right;
	background: transparent no-repeat center right;
}
#fullscreenbox_cl:hover, #fullscreenbox_cl.visible {
	background-repeat: no-repeat;
	background-position: center left;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACoAAAA8CAYAAAAQTCjdAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAgpJREFUeNrsmkFHRFEUx8/L20RE0eatZ94implNEW2KSG0jItrUN2gVbaNVXyLmAwwRERFDvJk280ZEPOIxqyEyo87Ru5E06t57rnOZP39mMff4Ofe9c+899wXvKOBXgj5EN3UDBI5AlU7RJ+g36aCkO/Q2OpMOSnpGr6NT6aCkHL2GfpAOSnpBr6AfpYNCAbmE7kkHJTXQWz6Ako7QZz6AUm2d/+15lQRKui4qgXhQ0g667gNoWjwCQ+mgpF30hQ+gtFot+AAKxSLwtS2cALk6cJ7RwWAAYRj+d1gfPYd+dZLRdrsNeZ7rDJ1CrzqZeoLsdDomITbVj5ALstVqQZqmpmF4M2oJkhSjp1lALUIqLVoHZYC0D8oEqabfDigjJCmy8tYnSQLdbpezykXGGXUASZoxAnUEqVYoPdAsy1xBkia1QaMoglKp5Ap0aDT1tVrNFWzf+GUi2HK5LB+UVK1WuWHtgDqAzawuoYywdkEVbBzHHOd8+9u8SqViG7bJtnG2DHvPemayBEudvR7rmUnBBkFgEuLKh3M9ibrQDWegmqLGw6yzBoSB6gpSeka/NcnGbUdDedHI9aY1/iObEkFv4fNuFCSDjrwQk1RHj2HELbOUjF6iN0b9YXwN/kdRc38ZhH9YQBlcVxtjqaBefPxyg94rYEEiaL8oQec6g12BUhb30U+6AT4EGACKTBrF+rBJrQAAAABJRU5ErkJggg==);
}
#fullscreenbox_cr:hover, #fullscreenbox_cr.visible {
	background-repeat: no-repeat;
	background-position: center left;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAAA8CAYAAACQPx/OAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAnRJREFUeNrsnLFrWlEUh69GAoIQEITCg0Ch+lysSkFooDR0KA35AzJkypI5SyBDpy7NmqkUOnUISNdCIZBCoUsCAbUUfJIp4CTJFCgUgzm3PJDSJvr0nvcOnN8Hv/Hde/DjvOe93mdqNBoZMJEG5T2lxj1RGp/1vSxS3lJO4pBhyeAzvxOP8onyNM5JIeT/+JQjynLcE0PIv1Qox5RCEpPjGfI3j8LOKCRVAISMyVO+UB4kWQSEjPkYdoiBkOTZpaxLKCSFheGfrvgZrjkMOiR5PkiRASHGbFCeSypI8y1rIbxV+ZKKSivvDl9aUZqF7EksSqsQu51egRA5bEstTKOQbPj8iMRwOIQQJl5QclEvGgwGptPpQAgDM2+RdLtd0263IYShQ2YmCAJWKdqELLlYe3BK0Sak4WogLinahDxxORiHFG1CnP8A5VqKNiEPOQa1UlqtFoTMgMc1cK/XcyJFm5A85+AupGgTkuOeYF4p2oRk45jESun3+xAihWKxaDzPg5Ap+BWHjHq9jlvWlFxLlqFRyBXXwKVSaW4ZGoX0uWTUam7e54EQQTIs2t4PCVwO5vu+qVarTgvU1iGnkmVoFHImWYbWb1mBVBlaV+pfZ72wXC6zyrBoPGxtT518jnqRPZeVyfB/B9IoxG4wXpqYNhpxy5qM3c9qSi1O627vOwiRtx75ASGy2IcQWTSN460UCJmPG8obCJHFIeU7hMhii/IbQuRwTnktpRj8tcYY+09Ar9AhctgMuwVChGC35tcoAwiR9Tx5aRhPp0BIdOzB3BXKBYTIwa7gn1G+QYgcbIesUnYM84lHCInGAeVxXN1yK8AAv3yVBKiuqjUAAAAASUVORK5CYII=);
}
/* classes to mark our images */
div.fullimg {
	position: relative;
	display: inline-block;
}
div.fullimg img {
	cursor: pointer;
}
div.fullimg img + div, #fullscreenbox_magnify {
	position: absolute;
	top: 0;
	right: 0;
	background-repeat: no-repeat;
	background-position: top right;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABBxJREFUeNrsl31oG2Ucx++5u1wud5f3tEnXhdmkTWyHVEX6lxWtUHWKHYrKxE1B/GND/xmIOhwORYbooP41RBChgoWWweh0+Ids/lXd6Nqha01jmto0adIsbV7uJffy3Plc0albX9LGUoQe3PF7uHvu+dz393K/B9DRcyPYDh44tsPHLsCOA5A1PWWowFAXaUMXCIBzGobbIAZwDAAaOuws4DiSEAQNlngN/ucAhla0GPIsGwnZmQ9PHGzu6Q55OcZya97MnFD+eiQ1NziSynIcJBZvVlVVM4xaAQjS98KL6y2uS1OO11+5t/n8wGvt0VYfp2kYnIyXivFkiVdVqIf32R0PdfkaDzwcaPg1USnJqqGXKiqsFQGsWQeQ7JAf8xw90rH309MvB0UJal8OzyZO9U/OVAS0ABRIDBYtkX2Eo/+D3nDPg60eqQq1w8evXhm/scxnclWlLgUMJcWEm/KBC4PvhET04rc/+vn60MV0TlF0Q5J1HeAUOm2wUCjrA4PfVdrb3Gzn/iDb3upgR8cKhRxyha7XkQV6NWE/9dazAdP+9lI29eP4Uim9IClLJUX7Wz+LAaxBEadb+UOv9s+nF5aVe6IOT2eHm3O5KLKuNDSUNPdEbxdblaE2/M18Np2VFEmGq34ToJoldAqnPxkommMUE74Gt9VSHwDysZ2zEciXohlS//ry1V5kbeHHJuKyaQebbIzHWacCCAHccgfUN45pQBiJmbRqmh4XZcVAvZUQkCty0zRBkBYcWEgA1q8XBWvvow/YTDs+y5flNdxVMwAgvdXJ2Jy8p5Fmg00M3RxgKGztiMWNatLe91Q3Yw6TKUHMFWS1LgCcDpXPfj6ybNpHXwqF/T4r1eizWgjiNiV0kdClmKPrPr/9uYPdzqWiIl8ezRdKG8TMxgpYW4TPBiYysXhGaruLc75/fH90r5+hPG6KXHGHoQFDW6L0apI90LPHd3H4ZIs5z6wZNoYgXCgI74DdVCVcUXaa89qy7ssXTrRGwg1sfkmWvjo3N/vTRLasQ5lwOzDqyZ6g/+nHov5/zptfkPhjJ69NTCd5aR6lL1ynMK8LgHIR6HKC9bJF+9kzh4N9j3c0rvZYLl+VSmVBj4S97GYhwIY9IYIw1CyNopy6uy1gPfTM/S6XkyVM7wGUepO/iaUvhpJZJxnzfj90pDPa1mTbDASouSk1ewJYRtUNoFaA1dDFIC0U5uQsBPoJ6XxxivEyOfel829Gbod4473x61OJivh7WpS3DrAh4J/uWgUis1gVnj82enXslyK/fS0ZcgduDQsF0b/8SN/H07H4gvTXrVRGFFBZ2mIMbFmJvOsHlD2prFZ+98yNWDonKYs37yxOYFs2JisQswzAab05GIYaCr7VFt8+gN19wS7A/wngDwEGAEZXMgRUiTJIAAAAAElFTkSuQmCC);
	visibility: hidden;
	width: 32px;
	height: 32px;
	cursor: pointer;
}
div.fullimg img:hover + div, div.fullimg img + div:hover, div.fullimg img + div.visible {
	visibility: visible;
}
#fullscreenbox_magnify {
	visibility: visible;
	top: 32px;
	right: 34px;
}
</style>
<script type="text/javascript" language="javascript">
/*
// File written by Jochen "Khuri" Dippel <khuri@khuris.com>
// Copyright 2014
// Last Update : 2014.02.04 11:16:12
*/
var js_lang_array=[];js_lang_array.js_fullscreenimg_js_info="<?php echo $L['js_fullscreenimg_js_info']?>";js_lang_array.js_fullscreenimg_js_image="<?php echo $L['js_fullscreenimg_js_image']?>";js_lang_array.js_fullscreenimg_js_image_connector="<?php echo $L['js_fullscreenimg_js_image_connector']?>";js_lang_array.js_fullscreenimg_js_error_notfound="<?php echo $L['js_fullscreenimg_js_error_notfound']?>";js_lang_array.js_fullscreenimg_js_image_fullscreen="<?php echo $L['js_fullscreenimg_js_image_fullscreen']?>"; fullscreenimg_zoomimg=!0;var fullscreenimgbox=null,fullscreen_items=[]; addonload(function(){for(var a=0;a<document.getElementsByTagName("img").length;a++)if(document.getElementsByTagName("img")[a].className.match(/fullimg/g)){is_nav||is_ie&&8<=ie_version?document.getElementsByTagName("img")[a].setAttribute("onclick","fullscreenbox('"+fullscreen_items.length+"',0);"):(document.getElementsByTagName("img")[a].subcounter=fullscreen_items.length,document.getElementsByTagName("img")[a].onclick=function(){fullscreenbox(this.subcounter,0)});if(fullscreenimg_zoomimg){var b=document.getElementsByTagName("img")[a].cloneNode(!0), c=document.createElement("div");c.setAttribute("class","fullimg");is_nav||is_ie&&8<=ie_version?c.setAttribute("onclick","fullscreenbox('"+fullscreen_items.length+"',0);"):(c.subcounter=fullscreen_items.length,c.onclick=function(){fullscreenbox(this.subcounter,0)});c.appendChild(b);b=document.createElement("div");!0!=/^hidden|\shidden\s|hidden$/.test(document.getElementsByTagName("img")[a].getAttribute("class"))&&is_mobile&&(b.className="visible");c.appendChild(b);document.getElementsByTagName("img")[a].parentNode.replaceChild(c, document.getElementsByTagName("img")[a])}fullscreen_items[fullscreen_items.length]=a}}); function fullscreenbox(a,b){if(isNaN(a)&&1!=b&&document.getElementById(a))for(var c=0;c<document.getElementsByTagName("img").length;c++)if(document.getElementsByTagName("img")[c]==document.getElementById(a)){!1===in_array(c,fullscreen_items)?(fullscreen_items[fullscreen_items.length]=c,a=fullscreen_items.length-1):a=in_array(c,fullscreen_items);break}if(null!=fullscreenimgbox&&1==b)fullscreenimgbox.fullscreenbox_close();else if((isNaN(a)||0<=a)&&null!=fullscreenimgbox&&1!=b){var d=fullscreenimgbox; if(0==d.fullscreen_displayed){d.fullscreen_displayed=1;d.refs.blackbox.style.width=document.documentElement.scrollWidth+"px";d.refs.blackbox.style.height=document.documentElement.scrollHeight+"px";d.createbody(!0,"magnify","box");d.createbody(!1,"loadingbox");d.opac("fullscreenbox_img",1);d.thetext.style.visibility="hidden";var e=!1,f=null;if(!isNaN(a))for(c=0;c<fullscreen_items.length;c++)c==parseInt(a)&&(e=c,f=fullscreen_items[parseInt(a)]);if(!isNaN(a)&&document.getElementsByTagName("img")[f]){if(gsource= document.getElementsByTagName("img")[f])tofile=gsource.getAttribute("src",1).replace(/(?:\.\/)?_thumbnails\/(.*)_resize_\d+(\.jpg)$|_thumbnails\//ig,"$1$2"),d.fullscreen_file.src=tofile,d.fullscreen_file.onload=function(){window.setTimeout(function(){if(null!=fullscreenimgbox){var a=fullscreenimgbox;a.refs.box.style.width="auto";a.refs.box.style.height="auto";a.timg.style.width=a.fullscreen_file.width+"px";a.timg.style.height=a.fullscreen_file.height+"px";is_nav||is_ie&&8<=ie_version?a.thetext.style.width= a.fullscreen_file.width+"px":a.thetext.setAttribute("width",a.fullscreen_file.width+"px");a.goleft.className="";a.goright.className="";a.next_id=e<fullscreen_items.length-1?e+1:0;a.prev_id=1<=e?e-1:fullscreen_items.length-1;if(1<fullscreen_items.length){if(is_nav||is_ie&&8<=ie_version?(a.goleft.setAttribute("onclick","fullscreenbox('"+a.prev_id+"',0);"),a.goright.setAttribute("onclick","fullscreenbox('"+a.next_id+"',0);")):(a.goleft.setAttribute("onclick",function(){fullscreenbox(a.prev_id,0)}),a.goright.setAttribute("onclick", function(){fullscreenbox(a.next_id,0)})),is_mobile)a.goleft.className="visible",a.goright.className="visible"}else a.goleft.className="hidden",a.goright.className="hidden";var b=window.document.documentElement.clientWidth,c=window.document.documentElement.clientHeight;if(!b||0>=b)b=560,c=420;a.createbody(!0,"loadingbox");toname=gsource.getAttribute("alt",1);a.timg.src=a.fullscreen_file.src;a.timg.width=0;a.timg.height=0;a.timg.title=a.striptags(toname);a.thetext.innerHTML=sprintf(js_lang_array.js_fullscreenimg_js_image, [e+1,fullscreen_items.length])+(""!=toname?js_lang_array.js_fullscreenimg_js_image_connector+toname:"");if(b<a.refs.box.offsetWidth||c<a.refs.box.offsetHeight){var d=a.innersize(a.refs.box,"width"),f=a.innersize(a.refs.box,"height"),f=a.refs.box.offsetHeight-f,h=a.innersize(a.timg,"width"),i=a.innersize(a.timg,"height"),g=a.timg.offsetWidth-a.innersize(a.timg,"width"),j=a.timg.offsetHeight-a.innersize(a.timg,"height");a.refs.box.style.width=b-(a.refs.box.offsetWidth-d)-a.scrollbarwidth()+"px";d=a.innersize(a.refs.box, "width");a.timg.style.width=d-g+"px";a.thetext.style.width=d-g+"px";a.timg.style.height=Math.round(parseInt(a.timg.style.width)*i/h-a.scrollbarwidth())+"px";if(c<a.refs.box.offsetHeight){do d=c-f-j-a.thetext.offsetHeight,b=Math.round(parseInt(a.timg.style.width)*d/parseInt(a.timg.style.height)-a.scrollbarwidth()),a.thetext.style.width=b+"px",a.timg.style.height=d+"px",a.timg.style.width=b+"px";while(parseInt(a.thetext.style.width)>parseInt(a.timg.style.width));f=a.innersize(a.refs.box,"height");a.refs.box.style.height= c-(a.refs.box.offsetHeight-f)+"px";a.refs.box.style.width=b+g+"px"}if(is_nav||is_ie&&8<=ie_version)a.createbody(!1,"magnify","box"),a.refs.magnify.setAttribute("title",js_lang_array.js_fullscreenimg_js_image_fullscreen)}scrolly=window.pageYOffset||self.pageYOffset||document.documentElement&&document.documentElement.scrollTop||document.body.scrollTop;movex=Math.round(a.refs.box.offsetWidth/2);movey=scrolly-Math.round(a.refs.box.offsetHeight/2);is_nav||is_ie&&8<=ie_version?(a.refs.box.style.marginLeft= "-"+movex+"px",a.refs.box.style.marginTop=movey+"px"):(a.refs.box.style.setAttribute("marginLeft","-"+movex+"px",!1),a.refs.box.style.setAttribute("marginTop",movey+"px",!1));a.refs.box.style.visibility="visible";a.timg.style.visibility="visible";a.thetext.style.visibility="visible";a.opac("fullscreenbox_img",2);window.setTimeout(function(){if(fullscreenimgbox!=null)fullscreenimgbox.fullscreen_displayed=0},a.opac_multi*a.opac_speed)}},d.opac_multi*d.opac_speed)},d.fullscreen_file.onerror=function(){var a= fullscreenimgbox;alert(sprintf(js_lang_array.js_fullscreenimg_js_error_notfound,[a.fullscreen_file.src]));fullscreenimgbox.fullscreen_displayed=0;a.fullscreenbox_close()},d.fullscreen_file.src=d.fullscreen_file.src}else fullscreenimgbox.fullscreen_displayed=0,d.fullscreenbox_close()}}else 0<fullscreen_items.length&&null==fullscreenimgbox&&(fullscreenimgbox=new fullscreenimg,fullscreenimgbox.fullscreenbox_init(),fullscreenimgbox.createbody(!1,"blackbox"),fullscreenimgbox.opac("fullscreenbox_blackbox", 2,90),fullscreenimgbox.createbody(!1,"closebutton","box"),fullscreenimgbox.createbody(!1,"loadingbox"),fullscreenbox(a,0))}function fullscreenimg(){null==fullscreenimgbox&&0<fullscreen_items.length&&(this.refs=[],this.fullscreen_file=new Image,this.fullscreen_displayed=this.prev_id=this.next_id=0,this.opac_multi=this.opac_speed=20,this.oldonkeyup=document.onkeyup,document.onkeyup=this.scrollimg)} fullscreenimg.prototype.fullscreenbox_init=function(){this.createbody(!1,"box");this.timg=document.createElement("img");this.timg.setAttribute("id","fullscreenbox_img");this.refs.box.appendChild(this.timg);this.goleft=document.createElement("div");this.goleft.setAttribute("id","fullscreenbox_cl");this.goleft.setAttribute("title",js_lang_array.js_fullscreenimg_js_info);this.goright=document.createElement("div");this.goright.setAttribute("id","fullscreenbox_cr");this.goright.setAttribute("title",js_lang_array.js_fullscreenimg_js_info); this.refs.box.appendChild(this.goleft);this.refs.box.appendChild(this.goright);this.thetext=document.createElement("div");this.thetext.setAttribute("id","fullscreenbox_text");this.refs.box.appendChild(this.thetext)}; fullscreenimg.prototype.fullscreenbox_close=function(){null!=fullscreenimgbox&&0==fullscreenimgbox.fullscreen_displayed&&(fullscreenimgbox.opac("fullscreenbox_blackbox",1,90),window.setTimeout(function(){null!=fullscreenimgbox&&fullscreenimgbox.createbody(!0,"blackbox")},fullscreenimgbox.opac_multi*fullscreenimgbox.opac_speed),fullscreenimgbox.createbody(!0,"loadingbox"),fullscreenimgbox.createbody(!0,"box"),document.onkeyup=fullscreenimgbox.oldonkeyup,window.setTimeout(function(){null!=fullscreenimgbox&& (fullscreenimgbox=null)},fullscreenimgbox.opac_multi*fullscreenimgbox.opac_speed))};fullscreenimg.prototype.scrollimg=function(a){null!=fullscreenimgbox&&0==fullscreenimgbox.fullscreen_displayed&&(a||(a=window.event),(code=a.charCode&&0==a.keyCode?a.charCode:a.keyCode)&&null!=fullscreenimgbox&&(37==code||39==code?fullscreenbox(37==code?fullscreenimgbox.prev_id:fullscreenimgbox.next_id,0):27==code&&fullscreenbox(0,1)))}; fullscreenimg.prototype.createbody=function(a,b,c){a?null!=this.refs[b]&&(c&&document.getElementById("fullscreenbox_"+c)?document.getElementById("fullscreenbox_"+c).removeChild(this.refs[b]):document.body.removeChild(this.refs[b]),this.refs[b]=null):null==this.refs[b]&&(this.refs[b]=document.createElement("div"),this.refs[b].setAttribute("id","fullscreenbox_"+b),"closebutton"==b||"blackbox"==b?this.refs[b].setAttribute("onclick",is_nav||is_ie&&8<=ie_version?"fullscreenimgbox.fullscreenbox_close();": function(){fullscreenimgbox.fullscreenbox_close()}):"magnify"==b&&this.refs[b].setAttribute("onclick",is_nav||is_ie&&8<=ie_version?"jsgoto('"+this.timg.src+"',"+(is_mobile?'""':'"fullscreenwindow"')+");":function(){jsgoto(this.timg.src,is_mobile?'""':'"fullscreenwindow"')}),c?document.getElementById("fullscreenbox_"+c).appendChild(this.refs[b]):document.body.appendChild(this.refs[b]))}; fullscreenimg.prototype.opac=function(a,b,c,d){if(null!=fullscreenimgbox){var e=[d/this.opac_multi,d*100*(1/this.opac_multi)];if(null==c||"undefined"!=typeof c)e=e[1]>c?[c/100,c]:e;if(document.getElementById(a)){if(!isNaN(e[0])&&!isNaN(e[1])){var f=document.getElementById(a).style;f.opacity=e[0];f.MozOpacity=e[0];f.KhtmlOpacity=e[0];f.filter="alpha(opacity="+e[1]+")"}if(null==d||"undefined"!=typeof d)d=2==b?0:this.opac_multi;if(0<b)if(2==b)for(b=0;b<=this.opac_multi;b++)window.setTimeout("if(fullscreenimgbox != null) {fullscreenimgbox.opac('"+ a+"',0,"+c+","+b+");}",b*this.opac_speed);else for(b=this.opac_multi;0<=b;b--)window.setTimeout("if(fullscreenimgbox != null) {fullscreenimgbox.opac('"+a+"',0,"+c+","+b+");}",(this.opac_multi-b)*this.opac_speed)}if(d==this.opac_multi)return!0}}; fullscreenimg.prototype.innersize=function(a,b){return"width"==b?a.offsetWidth-(("NaN"!=parseInt(getcssprop(a,"paddingLeft"))?parseInt(getcssprop(a,"paddingLeft")):0)+("NaN"!=parseInt(getcssprop(a,"paddingRight"))?parseInt(getcssprop(a,"paddingRight")):0)+("NaN"!=parseInt(getcssprop(a,"borderLeftWidth"))?parseInt(getcssprop(a,"borderLeftWidth")):0)+("NaN"!=parseInt(getcssprop(a,"borderRightWidth"))?parseInt(getcssprop(a,"borderRightWidth")):0)):"height"==b?a.offsetHeight-(("NaN"!=parseInt(getcssprop(a, "paddingTop"))?parseInt(getcssprop(a,"paddingTop")):0)+("NaN"!=parseInt(getcssprop(a,"paddingBottom"))?parseInt(getcssprop(a,"paddingBottom")):0)+("NaN"!=parseInt(getcssprop(a,"borderTopWidth"))?parseInt(getcssprop(a,"borderTopWidth")):0)+("NaN"!=parseInt(getcssprop(a,"borderBottomWidth"))?parseInt(getcssprop(a,"borderBottomWidth")):0)):0}; fullscreenimg.prototype.scrollbarwidth=function(){var a=document.body.style.overflow;document.body.style.overflow="hidden";var b=document.body.clientWidth;document.body.style.overflow="scroll";(b-=document.body.clientWidth)||(b=document.body.offsetWidth-document.body.clientWidth);document.body.style.overflow=a;return b};fullscreenimg.prototype.striptags=function(a){a=a.replace(/<br(?: \/)??>/ig," | ");a=a.replace(/<([\s\S]*?)>/ig," ");a=a.replace(/^\s+|\s+$/ig,"");return a=a.replace(/\s+/ig," ")}; var clientbrowser=navigator.userAgent.toLowerCase(),is_ie=-1!=clientbrowser.indexOf("msie")&&-1==clientbrowser.indexOf("opera"),is_nav=-1!=clientbrowser.indexOf("mozilla")&&-1==clientbrowser.indexOf("compatible"),ie_version=getInternetExplorerVersion(),is_mobile=/android|blackberry|ipad|iphone|ipod|mini|palm|windows\sce/i.test(navigator.userAgent.toLowerCase()); function getInternetExplorerVersion(){var a=-1;"Microsoft Internet Explorer"==navigator.appName&&null!=/MSIE ([0-9]{1,}[.0-9]{0,})/.exec(navigator.userAgent)&&(a=parseFloat(RegExp.$1));return a}function addonload(a){if("function"==typeof a){var b=window.onload;window.onload="function"!=typeof window.onload?a:function(){b&&b();a()}}}function jsgoto(a,b){if(0!=b&&"undefined"!=typeof b){if(0!=a){if(!0==b.closed||!b.document)b=window.open(a,b);b.location.href=a}b.focus()}else window.location.href=a} function trim(a){return null!=a&&"string"===typeof a?a.replace(/(^\s*)|(\s*$)/g,""):""}function isdefined(a){return void 0===this[a]?!1:!0}function getcssprop(a,b){return window.getComputedStyle?window.getComputedStyle(a,null)[b]:a.currentStyle?a.currentStyle[b]:a.style[b]}function sprintf(a,b){if(null!=a&&""!=a)for(var c=0;c<b.length;c++)a=a.replace(RegExp("(%"+(c+1)+")","m"),b[c]);return a}function in_array(a,b){for(var c=0;c<b.length;c++)if(a==b[c])return c;return!1};
</script>
</head>
<body>
	<?php
	if(!$hide_adminpanel) {
		if($showadminpanel) {
			echo '<div id="adminlogout"><a href="'.$thisfile.'?folder='.$subfolder.'" class="btn pointer">'.$L['admin_backtopage'].'</a></div>';
		}
		else {
	?>
	<div id="adminbox">
		<div class="adminlogin">
			<form action="<?php echo $thisfile;?>?adminpanel=true&amp;folder=<?php echo $subfolder;?>" method="post">
				<input type="password" name="adminlogin" />
				<input type="submit" value="<?php echo $L['login_btn'];?>" class="pointer" />
			</form>
		</div>
	</div>
	<?php
		}
	}
	?>
	<h1><?php
		echo sprintf($L['title'],(($foldername_nice) ? ucwords($foldername) : $foldername));
		?>
	</h1>
	<?php
	// Only display things if we are allowed to
	if($login_okay && !$showadminpanel) {
		// Display subfolders?
		if($link_to_subfolder) {
			if(!empty($cfolders) || $subfolder != "") {
				// fancy subfolders, show images from subfolder
				if($subfolder_fancy) {
					echo '<fieldset><legend>'.$L['subfolder'].'</legend>';
					echo '<ul class="subfolderfancy">';
					if($subfolder != "") {
						$subsplit = explode("/",preg_replace("%/$%","",$subfolder));
						array_pop($subsplit);
						$gosubfolder = (is_array($subsplit) && count($subsplit) >= 1) ? implode("/",$subsplit) : "";
						echo '<li><a href="./'.$thisfile.'?folder='.$gosubfolder.'"><div class="blankcard r3"></div><div class="blankcard r2"></div><div class="blankcard r1"><div>..</div></div><div class="textlink">'.$L['folder_parent'].'</div></a></li>';
					}
					// Get subfiles
					$f = new files();
					foreach($cfolders as $id => $name) {
						$f->setfolder($thumbnail_folder.$subfolder.$name,1,0);
						$f->folder_scan(0,0,false,$filefilter);
						$f->folder_sort("natcasesort");
						$si = $f->folder_recieve(0,0);
						echo '<li>';
						echo '<a href="./'.$thisfile."?folder=".$subfolder.$name.'">';
						// display images
						for($i=($subfolder_fancycount-1);$i>=0;$i--) {
							if(isset($si[$i]) && $si[$i] != "") {
								echo '<img class="r'.($i+1).'" src="'.$thumbnail_folder.$subfolder.$name.'/'.$si[$i].'" alt="Thumbnail '.($i+1).'" />';
							}
							else {
								echo '<div class="blankcard r'.($i+1).'"></div>';
							}
						}
						echo '<div class="textlink">'.(($foldername_nice) ? ucwords(str_replace("_"," ",$name)) : $name).'</div></a>';
						echo '</li>';
					}
					echo '</ul>';
					echo '</fieldset>';
					echo '<p>&nbsp;</p>';
				}
				else {
					echo '<fieldset><legend>'.$L['subfolder'].'</legend>';
					echo '<ul class="subfolder">';
					if($subfolder != "") {
						$subsplit = explode("/",preg_replace("%/$%","",$subfolder));
						array_pop($subsplit);
						$gosubfolder = (is_array($subsplit) && count($subsplit) >= 1) ? implode("/",$subsplit) : "";
						echo '<li><a href="./'.$thisfile.'?folder='.$gosubfolder.'">'.$L['folder_parent'].'</a></li>';
					}
					foreach($cfolders as $id => $name) {
						if(!preg_match($filefilter,$name)) {
							echo '<li><a href="./'.$thisfile."?folder=".$subfolder.$name.'">'.(($foldername_nice) ? ucwords(str_replace("_"," ",$name)) : $name).'</a></li>';
						}
					}
					echo '</ul>';
					echo '</fieldset>';
					echo '<p>&nbsp;</p>';
				}
			}
		}
		if(!empty($cfiles)) {
			// Images missing?
			if($image_missing > 0) {
				echo '<fieldset class="an">';
				// Images transforming
				if($image_missing > 0 && $cif) {
					echo '<p>'.sprintf($L['thumbnail_sum'],$image_missing).'</p>';
					// Error while creating thumbnail?
					if($images_error) {
						echo '<p class="anb">'.sprintf($L['error_thumbnail'],$images_missing_array[0]).'</p>';
					}
					echo '<div id="pageloading"></div>';
				}
				if(!$cif) {
					echo $L['thumbnail_missing'].'<br /><br />';
					echo '<a href="'.$thisfile.'?folder='.$subfolder.'&amp;cif=true" class="pointer"><strong>'.str_replace('"','',$L['thumbnail_create_btn']).'</strong></a>';
					// Try writing in thumbnail folder
					$files->setfolder($thumbnail_folder,1,0);
					$files->setfile("tmpfile");
					if(!$files->setfolder($thumbnail_folder,1)) {
						echo '<p class="anb">'.sprintf($L['error_folder'],$thumbnail_folder).'</p>';
					}
					elseif(!$files->writefile("ok")) {
						echo '<p class="anb">'.sprintf($L['error_folder'],$thumbnail_folder).'</p>';
					}
				}
				echo '</fieldset>';
				echo '<p>&nbsp;</p>';
			}
		}
		if(!$cif) {
			$files->setfolder("./",1);
			// Display images
			echo '<fieldset><legend>'.sprintf($L['files'],$image_sum).'</legend>';
			echo '<table id="photos">';
			echo '<tbody>';
			$i = 0;
			if(!empty($cfiles)) {
				// get imagetext first
				$imagetext = array();
				$tf = @fopen($thumbnail_folder.$subfolder."imagetext.csv",'r');
				if($tf) {
					while(($data = fgetcsv($tf,1000,',','"')) !== false) {
						$imagetext[$data[0]] = base64_decode($data[1]);
					}
				}
				foreach($cfiles as $id => $name) {
					if($i == 0) {
						echo '<tr>';
						$i++;
					}
					if(!in_array($name,$images_missing_array)) {
						echo '<td class="textinfo"><div class="nb">';
						$files->setfile($subfolder.$name);
						// display based on order
						foreach($thumbnail['showhistory'] as $k => $option) {
							if($option == 'image') {
								echo '<img src="'.$thumbnail_folder.$subfolder.$name.'" alt="'.str_replace('"','',(($thumbnail['show_imagetext'] && isset($imagetext[$name]) && $imagetext[$name] != "") ? nl2br($imagetext[$name],true) : $name)).'" class="fullimg" /><br />';
							};
							if($option == 'download' && $thumbnail['show_download']) {
								echo '<div class="dl"><a href="./'.$thisfile."?folder=".$subfolder."&amp;filedownload=".$name.'" class="btn">'.$L['download'].'</a></div>';
							}
							if($option == 'highresdownload' && $thumbnail['show_highresdownload']) {
								echo '<div class="dl"><a href="./'.$thisfile."?folder=".$subfolder.$hdfolder."/"."&amp;filedownload=".$name.'" class="btn spacel">'.$L['download_highres'].'</a></div>';
							}
							if($option == 'imagetext' && $thumbnail['show_imagetext'] && isset($imagetext[$name]) && $imagetext[$name] != "") {
								echo '<div class="imgname">'.nl2br($imagetext[$name],true).'</div>';
							}
							if($option == 'name' && $thumbnail['show_name']) {
								echo '<a href="./'.$subfolder.$name.'" target="fsi">'.(($filename_nice) ? ucwords(preg_replace('/\.[a-z0-9]+$/i','',str_replace("_"," ",$name))) : $name).'</a><br />';
							}
							if($option == 'filesize' && $thumbnail['show_filesize']) {
								echo $files->file_size(0,true).'<br />';
							}
							if($option == 'date' && $thumbnail['show_date']) {
								echo date($date_stamp,filemtime($thumbnail_folder.$subfolder.$name)).'<br />';
							}
							if($option == 'dimension' && $thumbnail['show_dimension']) {
								echo $files->image_info[0].' x '.$files->image_info[1].' px<br />';
							}
						}
						echo '</div></td>';
					}
					if($i / $thumbnail['imagesonrow'] == 1) {
						echo '</tr><tr>';
						$i = 0;
					}
					$i++;
				}
			}
			else {
				echo '<tr><td>'.$L['nofiles'].'</td></tr>';
			}
			if($i > 1) {
				for(;$i<=$thumbnail['imagesonrow'];$i++) {
					echo '<td>&nbsp;</td>';
				}
				echo '</tr>';
			}
			echo '</tbody>';
			echo '</table></fieldset>';
		}
	}
	// or show adminpanel
	elseif($showadminpanel && $login_admin) {
		$files = new files();
		// admin actions
		// cleanup thumbnails
		if(isset($_GET['cleanup']) && $_GET['cleanup'] == "true" && isset($_POST['cleanupfolder'])) {
			$clf = $_POST['cleanupfolder'];
			if($clf != "_all_") {
				$files->setfolder($thumbnail_folder.$clf,1,0);
				$files->folder_scan(0);
				foreach($files->folder_recieve() as $id => $picture) {
					$files->find_file($picture,0,1);
				}
			}
			else {
				$files->setfolder($thumbnail_folder,1,0);
				$files->folder_scan(1);
				$fa = array();
				foreach($files->folder_tree as $foldername => $sub) {
					foreach($sub['file'] as $id => $picture) {
						$files->setfolder($foldername,1,0);
						$files->find_file($picture,0,1);
					}
					$fa[] = $foldername;
				}
				foreach(array_reverse($fa) as $id => $folder) {
					$files->setfolder($folder,1,0);
					$files->deletefolder();
				}
			}
			echo '<fieldset class="an">';
			echo '<p>'.$L['admin_done'].'</p>';
			echo '</fieldset>';
			echo '<p>&nbsp;</p>';
		}
		// store image texts
		elseif(isset($_GET['storetext']) && $_GET['storetext'] == "true" && isset($_POST['data'])) {
			// make sure thumbnail-folder exists and can be written
			if(!$files->setfolder($thumbnail_folder.$subfolder,1,1)) {
				echo '<p class="anb">'.sprintf($L['error_folder'],$thumbnail_folder).'</p>';
			}
			// get submitted data
			else {
				// check if we can write file
				$tf = @fopen($thumbnail_folder.$subfolder."imagetext.csv",'w');
				if(!$tf) {
					echo '<p class="anb">'.sprintf($L['error_folder'],$thumbnail_folder).'</p>';
				}
				else {
					$data = $_POST['data'];
					if(is_array($data) && !empty($data) && isset($data[0]['text'])) {
						foreach($data as $i => $d) {
							$a = array($d['img'],base64_encode(substr($d['text'],0,400)));
							fputcsv($tf,$a,',','"');
						}
					}
					fclose($tf);
				}
			}
		}
		// outputs
		// thumbnail cleanup
		{
			echo '<fieldset><legend>'.$L['title_admin'].'</legend>';
			echo '<table id="photos">';
			echo '<tbody>';
			echo '<tr><td>';
			echo '<form action="'.$thisfile.'?adminpanel=true&amp;cleanup=true" method="post">';
			echo $L['admin_cleanup'];
			echo '<select name="cleanupfolder"><option value="_all_">'.$L['admin_cleanup_all'].'</option>';
			$files->folder_clean();
			$files->setfolder("./",1,0);
			$files->folder_scan(1,1);
			foreach($files->folder_tree as $foldername => $sub) {
				$linkname = str_replace("./","",$foldername);
				echo '<option value="'.$linkname.'"'.(($linkname == $subfolder) ? ' selected="selected"' : '').'>'.$foldername.'</option>';
			}
			echo '</select>';
			echo '<input type="submit" value="'.$L['admin_btn_submit'].'" class="pointer" />';
			echo '</form></td></tr>';
			echo '</table></fieldset>';
			echo '<p>&nbsp;</p>';
		}
		// image texts
		{
			echo '<fieldset><legend>'.$L['title_admin_textfolder'].'</legend>';
			echo '<table id="photos">';
			echo '<tbody>';
			echo '<tr><td>';
			echo '<form action="'.$thisfile.'" method="get" onchange="this.submit();">';
			echo '<input type="hidden" name="adminpanel" value="true" />';
			echo $L['admin_textfolder'];
			echo '<select name="folder">';
			$files->folder_clean();
			$files->setfolder("./",1,0);
			$files->folder_scan(1,1);
			foreach($files->folder_tree as $foldername => $sub) {
				$linkname = str_replace("./","",$foldername);
				echo '<option value="'.$linkname.'"'.(($linkname == $subfolder) ? ' selected="selected"' : '').'>'.$foldername.'</option>';
			}
			echo '</select>';
			echo '<input type="submit" value="'.$L['admin_btn_switch'].'" class="pointer" />';
			echo '</form></td></tr>';
			echo '<tr><td><hr /></td></tr>';
			// show images of current folder
			echo '<tr><td>';
			echo '<form action="'.$thisfile.'?adminpanel=true&amp;storetext=true&amp;folder='.$subfolder.'" method="post">';
			echo '<table id="photos">';
			echo '<tbody>';
			// get imagetext first
			$imagetext = array();
			$tf = @fopen($thumbnail_folder.$subfolder."imagetext.csv",'r');
			if($tf) {
				while(($data = fgetcsv($tf,1000,',','"')) !== false) {
					$imagetext[$data[0]] = base64_decode($data[1]);
				}
			}
			// parse images
			$i = 0;
			$ii = 0;
			if(!empty($cfiles)) {
				foreach($cfiles as $id => $name) {
					if($i == 0) {
						echo '<tr>';
						$i++;
					}
					echo '<td><div class="nb">'.((file_exists($thumbnail_folder.$subfolder.$name)) ? '<div style="position: relative; display: inline-block;"><img src="'.$thumbnail_folder.$subfolder.$name.'" alt="'.str_replace('"','',$name).'" /></div><br />' : '<div class="imgmiss"></div>').'<div class="text">';
					$files->setfile($name);
					echo '<span class="textsmall">'.$name.'</span><br />';
					echo '<input type="hidden" name="data['.$ii.'][img]" value="'.$name.'" />';
					echo '<textarea name="data['.$ii.'][text]" rows="1" class="imgtext">'.((isset($imagetext[$name])) ? $imagetext[$name] : '').'</textarea>';
					echo '</div></div></td>';
					if($i / $thumbnail['imagesonrow'] == 1) {
						echo '</tr><tr>';
						$i = 0;
					}
					$i++;
					$ii++;
				}
			}
			else {
				echo '<tr><td>'.$L['nofiles'].'</td></tr>';
			}
			if($i > 1) {
				for(;$i<=$thumbnail['imagesonrow'];$i++) {
					echo '<td>&nbsp;</td>';
				}
				echo '</tr>';
			}
			echo '</tbody>';
			echo '</table>';
			echo '<input type="submit" value="'.$L['admin_btn_save'].'" class="pointer" />';
			echo '</form></td></tr>';
			echo '</table></fieldset>';
		}
	}
	// login is not okay, display login screen
	else {
		echo '<fieldset><legend>'.$L['title_login'].'</legend>';
		echo '<form action="'.$thisfile.'" method="post">';
		echo '<label for="login">'.$L['password'].':</label>';
		echo '<input type="password" name="login" id="login" />';
		echo '<input type="submit" value="'.$L['login_btn'].'" class="pointer" />';
		echo '</form>';
		echo '</fieldset>';
	}
	?>
<p class="copynote">Powered by &quot;Instant Gallery&quot; - &copy; 2014 <a href="http://www.khuris.com/">Khuri's Media</a></p>
</body>
</html>