<?php
$source = (isset($_FILES['source'])) ? $_FILES['source'] : false;
$val = 0;
if($source !== false && is_array($source)) {
	$val = 1;
	$birthdays = [];
	$type = $_POST['type'];
	$reminder = (int)$_POST['reminder'];
	$timezone = $_POST['timezone'];
	$customText = !empty($_POST['custom_text']) ? $_POST['custom_text'] : '{NAME} hat Geburtstag';

	if(($handle = fopen($source['tmp_name'],'r')) !== false) {
		while(($d = fgetcsv($handle,0,',','"')) !== false) {
			if($d[13] != '' && preg_match('/(\d{4}|-)-(\d{2})-(\d{2})/', $d[13], $dates)) {
				$startyear = ($dates[1] != '-') ? $dates[1] : false;
				$birthdays[] = [
					'name' => $d[0].(($d[1] != '') ? ' '.$d[1] : '').' '.$d[2],
					'day' => $dates[3],
					'month' => $dates[2],
					'year' => $startyear,
				];
			}
		}
	}
	if(!empty($birthdays)) {
		$val = 2;
		$calendar_text = '';
		function s(string $k, string $s, bool $noreturn=false) {
			global $calendar_text;
			$calendar_text .= strtoupper($k).':'.$s.((!$noreturn) ? "\r\n" : '');
		}
		s('BEGIN','VCALENDAR');
		s('VERSION','2.0');
		s('PRODID','-//Khuri\'s Birthday Calendar//DE');
		s('CALSCALE','GREGORIAN');
		s('METHOD','PUBLISH');

		foreach($birthdays as $d) {
			$name_original = $d['name'];
			for($i=0;$i<=(($type == 'endless') ? 0 : 4);$i++) {
				// Skip dates that are in the past
				$eventYear = date('Y') + $i;
				$eventDate = mktime(0, 0, 0, (int)$d['month'], (int)$d['day'], $eventYear);
				if($eventDate < time() && $type != 'endless') {
					continue;
				}
				// Calculate age if applicable
				$age = ($d['year'] !== false && $type != 'endless') ? ((date('Y') + $i) - $d['year']) : false;
				$displayName = $name_original;
				if($age !== false) {
					$displayName = $name_original.' ('.$age.')';
				}

				// Replace {NAME} placeholder with actual name
				$eventTitle = str_replace('{NAME}', $displayName, $customText);

				// First Event: All-day birthday event
				s('BEGIN','VEVENT');
				s('SUMMARY', $eventTitle);
				s('uid','geb-allday-'.preg_replace('/[^a-z0-9_\-]/i', '', strtolower($name_original)).'-'.(date('Y') + $i).'-yearly');
				s('SEQUENCE',0);
				s('STATUS','CONFIRMED');
				s('TRANSP','TRANSPARENT');
				if($type == 'endless') {
					s('RRULE','FREQ=YEARLY;INTERVAL=1;BYMONTH='.$d['month'].';BYMONTHDAY='.$d['day']);
					s('DTSTART;VALUE=DATE',date('Y').$d['month'].$d['day']);
					s('DTEND;VALUE=DATE',date('Ymd',mktime(0,0,0,(int)$d['month'],((int)$d['day'] +1),date('Y'))));
				}
				else {
					s('DTSTART;VALUE=DATE',(date('Y') + $i).$d['month'].$d['day']);
					s('DTEND;VALUE=DATE',date('Ymd',mktime(0,0,0,(int)$d['month'],((int)$d['day'] +1),(date('Y') + $i))));
				}
				s('DTSTAMP',date('Ymd\THis\Z'));
				s('END','VEVENT');

				// Second Event: Timed reminder event (only if reminder is set)
				if($reminder > 0) {
					s('BEGIN','VEVENT');
					s('SUMMARY', '🎂 '.$eventTitle);
					s('uid','geb-reminder-'.preg_replace('/[^a-z0-9_\-]/i', '', strtolower($name_original)).'-'.(date('Y') + $i).'-yearly');
					s('SEQUENCE',0);
					s('STATUS','CONFIRMED');
					s('TRANSP','OPAQUE');

					// Format time as HHMM
					$timeStr = str_pad($reminder, 2, '0', STR_PAD_LEFT).'0000';

					if($type == 'endless') {
						s('RRULE','FREQ=YEARLY;INTERVAL=1;BYMONTH='.$d['month'].';BYMONTHDAY='.$d['day']);
						s('DTSTART;TZID='.$timezone,date('Y').$d['month'].$d['day'].'T'.$timeStr);
						s('DTEND;TZID='.$timezone,date('Y').$d['month'].$d['day'].'T'.str_pad(($reminder+1), 2, '0', STR_PAD_LEFT).'0000');
					}
					else {
						s('DTSTART;TZID='.$timezone,(date('Y') + $i).$d['month'].$d['day'].'T'.$timeStr);
						s('DTEND;TZID='.$timezone,(date('Y') + $i).$d['month'].$d['day'].'T'.str_pad(($reminder+1), 2, '0', STR_PAD_LEFT).'0000');
					}
					s('DTSTAMP',date('Ymd\THis\Z'));

					// Add alarm to the reminder event
					s('BEGIN','VALARM');
					s('ACTION','DISPLAY');
					s('TRIGGER;VALUE=DURATION','-PT0M');
					s('DESCRIPTION', $eventTitle);
					s('END','VALARM');
					s('END','VEVENT');
				}
			}
		}
		s('END','VCALENDAR',true);

		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream; charset=utf-8');
		header('Content-Disposition: attachment; filename=birthday_calendar.ics');
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		echo chr(239).chr(187).chr(191).$calendar_text;
		exit();
	}
}

// print output
?>
<html>
<head><title>Google Contacts to Birthday-Calendar (with Reminders)</title></head>
<style>
	body {
		font-family: Arial,sans-serif;
		line-height: 1.5em;
	}
	a {
		color: #828c95;
	}
	p {
		margin: 0 0 10px 0;
	}
	p + hr {
		margin-top: 10px;
	}
	p:last-child {
		margin-bottom: 0;
	}
	h1 {
		margin-top: 0;
	}
	form {
		padding: 20px;
		margin: 20px;
		border: 1px dashed #80878f;
	}
	hr {
		border: 1px dashed #80878f;
		margin: 20px 0;
	}
	label {
		display: block;
		padding: 0 0 10px 0;
	}
	label > * {
		display: block;
		margin-top: 10px;
	}
	select, option, input[type="text"] {
		padding: 5px 10px;
		width: 200px;
	}
	input[type="text"] {
		width: calc(100% - 22px);
		max-width: 400px;
		box-sizing: border-box;
	}
	button {
		margin-top: 20px;
		background-color: #000;
		color: #fff;
		padding: 10px 20px;
		font-weight: bold;
		border-radius: 4px;
		border: 1px solid #000;
	}
	button:hover {
		background-color: #fff;
		color: #000;
		cursor: pointer;
	}
	.di {
		font-size: 80%;
	}
	.note {
		font-size: 85%;
		color: #666;
		margin-top: 5px;
	}
	.r {
		border: 1px solid #ff5353;
		color: #ff5353;
		padding: 10px;
		margin: 20px;
	}
	.info-box {
		background-color: #e8f4f8;
		border: 1px solid #b8d4e0;
		padding: 10px;
		margin: 10px 0;
		border-radius: 4px;
	}
</style>
<body>
<form method="post" enctype="multipart/form-data">
	<h1>Google Contacts to Calendar Birthday Event (Reminder) Converter</h1>
	<p>If you have birthdays stored in your contacts and would like to see reminders in your calendar, then you can use this little form to convert your Google Contacts to a calendar ICS file.</p>
	<p><strong>How to use:</strong></p>
	<p>Go to your <a href="https://contacts.google.com/" target="_blank">Google Contacts Page</a>, click on <strong>the name icon/avatar</strong> on the left to check one, then on top select All or select your desired contacts.<br>On top right with the 3 dots select <strong>Export</strong> and as format <strong>Google CSV</strong> as type and hit Export.</p>
	<p>After converting you can simply create a new Google Calendar (or whatever Calendar you prefer) and import the generated <em>birthday_calendar.ics</em> file into it.</p>

	<div class="info-box">
		<p>Due to changes in how Google Calendar handles Day-Long events, this converter will now create 2 events per birthday:</p>
		<ul>
			<li>An all-day event for the actual birthday</li>
			<li>A timed reminder event at your chosen time (if reminder is enabled)</li>
		</ul>
		<p>You can also now set the text reminder and select your timezone.</p>
	</div>

	<p>If you like, you can download this scripts source code here: <a href="index.zip">index.php</a></p>

	<hr>
	<?php
	if($val === 1) {
		echo '<p class="r">Could not find any birthdays in file!</p>';
	}
	?>
	<label>
		Google Contacts-CSV
		<input type="file" name="source">
	</label>
	<label>
		Validity Period of Reminders
		<select name="type">
			<option value="endless">Forever (no age display)</option>
			<option value="10year">Next 5 Years (display age)</option>
		</select>
	</label>
	<label>
		Custom Event Text
		<input type="text" name="custom_text" value="{NAME} hat Geburtstag" placeholder="{NAME} birthday">
		<div class="note">{NAME} is a placeholder for the birthday person</div>
	</label>
	<label>
		Reminder Time
		<select name="reminder">
			<option value="0">No reminder event</option>
			<?php
			for($i=1;$i<=23;$i++) {
				echo '<option value="'.$i.'"'.(($i == 17) ? ' selected="selected"' : '').'>'.$i.':00 o\'clock</option>';
			}
			?>
		</select>
	</label>
	<label>
		Timezone for Reminder
		<select name="timezone">
			<?php
			$timezones = timezone_identifiers_list();
			foreach($timezones as $tz) {
				$selected = ($tz === 'Europe/Berlin') ? ' selected="selected"' : '';
				echo '<option value="'.$tz.'"'.$selected.'>'.$tz.'</option>';
			}
			?>
		</select>
	</label>
	<button type="submit">Convert</button>
	<hr>
	<p class="di">Disclaimer: Your data is only stored for the convertion on the server, then immediately deleted.</p>
</form>
</body>
</html>